/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package chapter9.datetime;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Utilities {

    public static String capitalise(String s) {
        //Convert the incoming string to an array of words (strings separated by spaces)
        String[] words = s.split(" ");//split only available for String class.
        //variable to store the results
        StringBuilder formattedString = new StringBuilder("");
        //Loop through each word, formatting it and then adding it to our result.
        for (String word : words) {
            //Use append to add a string to the string builder.
            formattedString = formattedString
                    .append(word.substring(0, 1).toUpperCase())
                    .append(word.substring(1).toLowerCase())
                    .append(" ");
        }
        //Remove the space from the end of the string.  trim is not available for StringBuilder class
        formattedString = formattedString.deleteCharAt(formattedString.length() - 1);

        //must convert from StringBuilder back to String before returning
        return formattedString.toString();
    }
}
